package gov.va.med.domain.service.messaging.transceiver;
//gov.va.med.domain.messaging.transceiver.HL7MLLPTransceiver
import gov.va.med.domain.service.messaging.MessagingException;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ca.uhn.hl7v2.Log;
import ca.uhn.hl7v2.llp.LLPException;

/**
 * HL7MLLPTransceiver
 *
 * @author Slava Uchitel
 * @version $Id: HL7MLLPTransceiver.java,v 1.4 2005/05/26 13:12:38 joel.goldberg Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
@Component("hl7MLLPTransceiver")
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class HL7MLLPTransceiver extends SocketTransceiver
{
    private static final String BEGIN_MARKER = "\u000B";
    private static final String END_MARKER = "\u001C\r";

    //private long startTime;
    //private long endTime;

    protected void sendMessage(String msg, OutputStream outStream) throws LLPException
    {
        String dataToSend = (BEGIN_MARKER + msg + END_MARKER);
        send(dataToSend, outStream);
    }

    protected String receiveMessage(InputStream inStream) throws LLPException
    {
        String result = receive(inStream, END_MARKER, BEGIN_MARKER.length());
        if(!(result.startsWith(BEGIN_MARKER)))
        {
            throw new LLPException("Incoming message format error - begin marker is missing.");
        }
        if(!(result.endsWith(END_MARKER)))
        {
            throw new LLPException("Incoming message format error - end marker is missing.");
        }
        result = result.substring(BEGIN_MARKER.length());
        result = result.substring(0, result.length() - END_MARKER.length());
        return result;
    }

    public Object transceive(Object payload)
    	throws MessagingException
    {
        InputStream is=null;
        OutputStream os=null;
        connect();
        try {
             is=getInputStream();
             os=getOutputStream();
            sendMessage((String)payload, os);
            return receiveMessage(is);
        } catch (LLPException e) {
        	String msg = "Unable to send/receive message over LLP protocol. Error: " + e;
        	getLogger().error(msg, e);
        	throw new MessagingException(msg, e);
		}
        finally {
        	if(is != null){
        		try {
					is.close();
				} catch (IOException e) {
					getLogger().error(e);
				}
        	}
        	if(os != null){
        		try {
					os.close();
				} catch (IOException e) {
					getLogger().error(e);
				}
        	}

        	disconnect();
        }
    }
}
